function [Msat,Minsertion,AntW,CEW,SCBDW,BLP,AKMDW,AKMImpulse,FSKLOC] = ...
    spacecraft(powerSat,ISL,GSKLOC,AKMIsp,StationIsp,alti,spaceLife,Risl,addSCMass,DSatT)
% function spacecraft.m
% Darren Chang (darrenz@mit.edu)
% Last modified by 8/1/03
% Using the scaling rule, this module
% takes satellite power and satellite
% antenna size as inputs and returns
% s/c mass, volume, subsystem mass,
% volume, etc.,

% problems yet to be solved:
% 1. find better correlations by riching the data
% 2. how to find antenna weight
% 3. estimate flight software KLOC

%function [Msat,Minsertion,AntW,CEW,SCBDW,BLP,AKMDW,AKMImpulse,FSKLOC,newSpaceLifeArray] = ...
%    spacecraft(powerSat,ISL,GSKLOC,AKMIsp,StationIsp,alti,spaceLife,spaceLife_i,Risl,addSCMass,DSatT)

G = 6.672e-11;      % [Nm^2/kg^2]
Mearth = 5.9736e24; % [kg]
Rearth = 6371.0;    % [km]

r = alti + Rearth;          % [km] 
V = sqrt(G*Mearth/r/1e9);   % s/c orbital velocity [km/s]
g = G*Mearth/(r*1000)^2; % [m/s^2]

% Dry mass of s/c w/o ISL in kg, estimated based FCC filing data 
% of 23 systems collected by Phil Springmann in Nov. 2002
Mdry = 11.025*powerSat^0.6076; 

% estimate the antenna mass
AntW  = 2*9.173*DSatT^1.403;  	% antenna weight estimation based on Table 13-16 in SMAD
                                % Assume two antennas, one for transmitting and the other for receiving

% estimated weight of 4 RF ISL links. Risl=0 for no ISL.  Source: Y. Koyama @ NeLS
if ISL == 0                         % no ISL
    Misl = 0;
elseif ISL == 1                     % all ISL
    if Risl < 100                   % data rate less than 100Mb/s
        Misl = 426;                 % [kg]
    else
        Misl = 480;
    end;
end;

% initial value of sat. mass
Msat = Mdry + Misl + addSCMass;           
Msat_diff = 10;

while Msat_diff/Msat > 0.0001
    Msat_prev = Msat;
    
    % find cross-section area of the s/c
    Vsat = Msat/234.18;                 % spacecraft volume in m^3, estimated from 15 existing systems 
                                    % FCC filing data collected by Phil Springmann in Nov. 2002
Vsat_noAnt	= (Msat - AntW)/234.18; 
radius  = (3/(4*pi)*Vsat_noAnt)^(1/3);
Axsection  = pi*radius^2 + 2*pi*(DSatT/2)^2;

   % [Vsat,Axsection] = scgeometry(Msat,AntW,DSatT);
    
    % add de-orbiting fuel mass
    % step 1, find delta V, using equation (6-54) in SMAD, assuming deorbit to 90% of original altitude
    deltaV = V*(1 - sqrt(2*(Rearth + alti*0.9)/((Rearth + alti*0.9) + r)))*1000;  % [m/s]

     % step 4, find sat. mass with fuel. Assuming deorbit engine has same Isp as Station keeping engine
     Mfuel_sat = Msat*exp(deltaV/g/StationIsp);

     % step 5, find fuel mass
     Mdeorbit = Mfuel_sat - Msat;
    
     
    Msat = Mdry + Misl + addSCMass + Mdeorbit;
    
    % add station-keeping fuel mass
    
Cd      = 2.2;                  % approx. value of drag coefficient. From SMAD P143
Cballistic = Msat/(Cd*Axsection);  % ballistic coefficient, [kg/m^2]
%Cballistic = ballistic(Msat,Axsection);
    
    
   % Mstation = station(Msat,alti,StationIsp,Cballistic,spaceLife,g,r,V);
    
    % alti - orbital altitude in [km]
% DryM - s/c dry mass in [kg]
% StationIsp  - AKM specific impulse in [sec]

% step 1, find density at different altitudes
rho = interp1([0 100 150 200 250 300 350 400 450 500 550 600 650 700 750 800 850 900 950 1000 1250 1500 2000 2500 3000 3500 ...
    4000 4500 5000 10000],...
    [1.2 5.25e-7 1.73e-9 2.41e-10 5.97e-11 1.87e-11 6.66e-12 2.62e-12 1.09e-12 4.76e-13 2.14e-13 9.89e-14 4.73e-14 2.36e-14 ...
        1.24e-14 6.95e-15 4.22e-15 2.78e-15 1.98e-15 1.49e-15 5.7e-16 2.79e-16 9.09e-17 4.23e-17 2.54e-17 1.77e-17 1.34e-17 ...
        1.06e-17 8.62e-18 2.37e-18],alti);

% step 2, find mean delta-V per year to maintain altitude
% equation from item 6 in the backsheet of SMAD
% r: [km], V: [km/s]
deltaV = pi/Cballistic*rho*(r*1000)*(V*1000)/(1.658669e-4*r^1.5/365/24/60); % [m/s/year]
% total delta V over space life
deltaV_t = deltaV*spaceLife;

% step 3, find sat. mass with fuel
Mfuel_sat = Msat*exp(deltaV_t/g/StationIsp);

% step 4, find fuel mass
Mstation = Mfuel_sat - Msat;
    Msat = Mdry + Misl + addSCMass + Mdeorbit + Mstation;
    
    Msat_diff = abs(Msat - Msat_prev);
end;
Mdry;
Misl;
addSCMass;
AntW;
Mdeorbit;
Mstation;

% estimate orbital AKM weight and impulse
Minsertion = 23.75*(Msat/277.6);
% step 1, find delta V required at apogee for insertion
%ra = 6371;      % earth radius [km]
%rb = ra + alti; % orbital altitude [km]
%atx = (ra + rb)/2; % transfer ellipse major axis
%Vfb = 631.3481*(rb)^-0.5;
%Vtxb = 631.3481*(2/rb - 1/atx)^0.5;
%dVinsertion = abs(Vfb - Vtxb);      % [km/s]

% step 1, find delta V for insertion
%Mfuel_sat = Msat*exp(dVinsertion*1000/g/AKMIsp);
dVinsertion = g*AKMIsp*log((Msat + Minsertion)/Msat);

% step 2, find impulse required of the AKM and AKM dry weight
AKMImpulse_kgms = Msat*dVinsertion;             % [kg*m/s = N*s]
AKMImpulse = AKMImpulse_kgms/9.8;               % [kg*s]
AKMDW = 2e-5*AKMImpulse_kgms;                   % [kg], estimated based on Table 17-7 in SMAD

% estimate spacecraft life length due to solar activities
%newSpaceLife = lifetime(Cballistic,alti,spaceLife(spaceLife_i));
%spaceLife(spaceLife_i) = newSpaceLife;
%newSpaceLifeArray = spaceLife;

% estimate the other useful parameters
CEW		= (Msat+Minsertion)*0.27;		    % communication electronics weight in kg, estimatd from existing systems
SCBDW	= (Msat+Minsertion)*0.436;		    % spacecrft bus dry weight in kg, estimatd from existing systems
BLP		= 2.61*powerSat;        % beginning of life power in Watts
FSKLOC	= GSKLOC;		% flight software thousand lines of code????????????
